/**
 * Created by lei.wang_1 on 2016.
 */
appModule.controller('ReceiverCtrl', ['$scope', 'api', '$timeout', 'utils', 'notices', 'pages', '$translate', 'log', function ($scope, api, $timeout, utils, notices, pages, translate, log) {
    $scope.noticeContainerId = "notices_container";
    $scope.SAVED_BOARD_ID = 'saved_notice_board_id';
    $scope.backToMain = function () {
        if ($scope.selectedAccount && $scope.selectedAccount.currentCategory) {
            return $scope.backToMessage();
        }
        $scope.showNotices = false;
        if ($scope.selectedAccount) {
            $scope.selectedAccount.categories = null; //清空分类列表
            $scope.selectedAccount.selectedItems = [];
            $scope.selectedAccount.messages = [];
        }
        $scope.selectedAccount = null;
    };

    $scope.updateSelectedAccount = function (account) {
        $scope.selectedAccount = account;
        api.setNoticesRead(account.board_id, function () {
            utils.applyScope($scope, function () {
                account.unread_count = 0;
            });
        }, function (msg) {
            log.logInfo("fail to set notices read: " + msg);
        });
        $scope.showNotices = true;
        $scope.selectedAccount.currentCategory = '';
        $scope.selectedAccount.categories = [];
        $scope.getMessages(account.board_id, 0, 0);
        var index = $scope.categories.findIndex(function (category) {
            return category.type == 'task';
        });
        if (index > -1) {
            $scope.getSelectedAccountTaskTodoCount(account.board_id);
        }
    };

    $scope.reloadAccounts = function(type){
        switch(type){
            case 'defalut':
                $scope.isReloading = true;
                break;
            case 'list':
                $scope.isListReloading = true;
                break;
        }

        $scope.init();
    };

    $scope.getSelectedAccountTaskTodoCount = function (accountId) {
        api.getTaskTodoCount(accountId, function (data) {
            if ($scope.selectedAccount.board_id == accountId) {
                utils.applyScope($scope, function () {
                    $scope.selectedAccount.taskTodoCount = data;
                    $scope.selectedAccount.taskTodoCountText = translate.instant('receive.task_todo_count', {todoCount: data});
                });
            }
        }, function (msg) {
            log.logInfo("fail to load task toco count: " + msg);
        });
    };

    $scope.time2str = function (t) {
        return utils.time2str(t / 1000);
    };

    $scope.onScrollDown = function () {
        utils.applyScope($scope, function () {
            if ($scope.isLoadingAccounts) {
                return;
            }
            $scope.isLoadingAccounts = true;
            var max = $scope.accounts[$scope.accounts.length - 1].created_at;
            api.getReceiverAccounts(0, max, function (data) {
                utils.applyScope($scope, function () {
                    $scope.accounts = $scope.accounts.concat(data);
                    $scope.isLoadingAccounts = false;
                });
            }, function (msg) {
                log.logInfo("get receiver accounts failed. user_id:" + api.getCurrentUser().userId + "; msg:" + msg);
                api.notifyError(msg);
                utils.applyScope($scope, function () {
                    $scope.isLoadingAccounts = false;
                })
            });
        });
    };

    $scope.onScrollUp = function (callback) {
        if (!$scope.selectedAccount) {
            return;
        }
        var since = 0, max = 0, accountId = $scope.selectedAccount.board_id, list;
        if ($scope.selectedAccount.currentCategory) {
            list = $scope.selectedAccount.categories[$scope.selectedAccount.currentCategory];
            if (list && list.length > 0) {
                max = list[0].feed_id;
            }
            $scope.getCategoryData(accountId, $scope.selectedAccount.currentCategory, since, max, callback);
        } else {
            list = $scope.selectedAccount.messages;
            if (list && list.length > 0) {
                max = list[0].feed_id;
            }
            $scope.getMessages(accountId, since, max, callback);
        }
    };

    $scope.showPreview = function (n) {
        var params = ['task_detail.html?'];
        if (!params) {
            return;
        }
        if (n.id) {
            params.push('id=' + n.id);
            if (n.detailUrl) {
                notices.getSessionInfo(function (session) {
                    var url = n.detailUrl + '&uc_account=' + utils.retrieveUser().account + '&uc_token=' + session + '&lang=' + appModule.lang + '&client_type=pc&v=5';
                    params.push('&detailURL=' + encodeURIComponent(url));
                    params.push('&link=' + n.link);
                    url = params.join('');
                    $scope.openDetailWindow(url);
                });
                return;
            }
        } else {
            params.push('localId=' + n.localId);
            params.push('&accountName=' + encodeURIComponent($scope.selectedAccount.name));
            params.push('&createTime=' + utils.time2str(n.createTimestamp ? n.createTimestamp / 1000 : Date.now() / 1000));
        }
        var url = params.join('');
        $scope.openDetailWindow(url);
    };

    $scope.openDetailWindow = function (url) {
        pages.openModalDialog(url, 'detail', 760, 720, $scope, {
            modal: false,
            caption: [{
                left: 0,
                top: 5,
                width: 90,
                height: 20
            }, {
                left: 150,
                top: 5,
                width: -100,
                height: 40
            }],
            resizable: true,
            refreshIfExist: true,
            enableDrag: true,
            behaviorIfSCClose: 0,
            showCloseButton: true,
            showMinimalButton: true,
            showFullScreenButton: true,
            macResolution: {width: 760, height: 670}
        });
    };

    $scope.convertTime = function (source) {//将日期转化成视觉要求
        return notices.convertNoticeTime(source);
    };

    $scope.dateFilter = function (n, index, arrays) {
        var year, month, date, dateStr;
        var nowDate = new Date();
        var curDate = new Date();
        var yesterday = new Date();
        curDate.setTime(n.createTimestamp);
        yesterday.setDate(nowDate.getDate() - 1);
        if (index > 0) {
            var nextDate = new Date();
            nextDate.setTime(arrays[index - 1].createTimestamp);
            if (curDate.getFullYear() != nextDate.getFullYear()) {
                year = curDate.getFullYear();
                month = curDate.getMonth() >= 9 ? curDate.getMonth() + 1 : "0" + (curDate.getMonth() + 1);
                date = curDate.getDate() > 9 ? curDate.getDate() : "0" + curDate.getDate();
                dateStr = year + "/" + month + "/" + date;
            } else if (curDate.getMonth() != nextDate.getMonth() || curDate.getDate() != nextDate.getDate()) {
                month = curDate.getMonth() >= 9 ? curDate.getMonth() + 1 : "0" + (curDate.getMonth() + 1);
                date = curDate.getDate() > 9 ? curDate.getDate() : "0" + curDate.getDate();
                dateStr = month + "/" + date;
            }
        } else {
            year = curDate.getFullYear() == nowDate.getFullYear() ? "" : curDate.getFullYear();
            month = curDate.getMonth() >= 9 ? curDate.getMonth() + 1 : "0" + (curDate.getMonth() + 1);
            date = curDate.getDate() > 9 ? curDate.getDate() : "0" + curDate.getDate();
            if (year) {
                dateStr = year + "/" + month + "/" + date;
            } else {
                dateStr = month + "/" + date;
            }
        }

        if (dateStr) {
            if (curDate.toDateString() == nowDate.toDateString()) {
                n.dateSpliter = translate.instant("common.today");
            } else if (curDate.toDateString() == yesterday.toDateString()) {
                n.dateSpliter = translate.instant("common.yesterday");
            } else {
                n.dateSpliter = dateStr;
            }
        } else {
            n.dateSpliter = null;
        }

        return true;
    };

    $scope.convertBadgeNumber = function (num) {
        return utils.convertBadgeNumber(num);
    };

    $scope.onCategoryChanged = function (type, e) {
        if (e) {
            e.stopPropagation();
        }
        $scope.selectedAccount.currentCategory = type;
        if (!$scope.selectedAccount.categories) {
            $scope.selectedAccount.categories = {};
        }
        var list = $scope.selectedAccount.categories[type];
        if (!list) {
            $scope.selectedAccount.categories[type] = [];
        }
        var max = 0, since = 0;

        $scope.getCategoryData($scope.selectedAccount.board_id, type, since, max);
    };

    $scope.getCategoryData = function (accountId, categoryType, since, max, callback) {
        $scope.isLoadingData = true;

        api.getCategoryData(accountId, categoryType, since, max, function (data) {
            utils.applyScope($scope, function () {
                $scope.isLoadingData = false;
                var accountIndex = $scope.accounts.findIndex(function (ac) {
                    return ac.board_id == accountId;
                });
                if (accountIndex > -1) {
                    if(!$scope.accounts[accountIndex].categories[categoryType]){
                        $scope.accounts[accountIndex].categories[categoryType] = [];
                    }
                    if (since==max && since > 0) {
                        var index = $scope.accounts[accountIndex].categories[categoryType].findIndex(function (item) {
                            return item.feed_id == data[0].feed_id;
                        });
                        if (index > -1) {
                            $scope.accounts[accountIndex].categories[categoryType].splice(index, 1, data[0]);
                        } else {
                            $scope.accounts[accountIndex].categories[categoryType].push(data[0]);
                            $timeout(function () {
                                $scope.$broadcast("scrollToBottom", "notices_container");
                            });
                        }
                    } else if (max > 0) {
                        $scope.accounts[accountIndex].categories[categoryType] = data.concat($scope.accounts[accountIndex].categories[categoryType]);
                    } else {
                        $scope.accounts[accountIndex].categories[categoryType] = data;
                        if (data.length > 0) {
                            $timeout(function () {
                                $scope.$broadcast("scrollToBottom", "notices_container");
                            });
                        }
                    }
                    $scope.accounts[accountIndex].selectedItems = $scope.accounts[accountIndex].categories[categoryType];
                }
            });

            if (callback) {
                callback(data);
            }
        }, function (msg) {
            $scope.isLoadingData = false;
        });
    };

    $scope.getMessages = function (accountId, since, max, callback) {
        $scope.isLoadingData = true;
        utils.applyScope($scope, function () {
            api.getCategoryData(accountId, '', since, max, function (data) {
                utils.applyScope($scope, function () {
                    if (data.length > 0) {
                        var accountIndex = $scope.accounts.findIndex(function (ac) {
                            return ac.board_id == accountId;
                        });
                        if (accountIndex > -1) {
                            if (max > 0) {
                                if(max == since){ //拉取新消息
                                    $scope.accounts[accountIndex].messages.push(data[0]);
                                    $timeout(function () {
                                        $scope.$broadcast("scrollToBottom", "notices_container",false,$scope.accounts[accountIndex].messages.length);
                                    });
                                }else{
                                    $scope.accounts[accountIndex].messages = data.concat($scope.accounts[accountIndex].messages);
                                }
                            }  else {
                                $scope.accounts[accountIndex].messages = data;
                                $scope.accounts[accountIndex].title = data[data.length - 1].topic;
                                $scope.accounts[accountIndex].created_at = data[data.length - 1].createTimestamp;
                                $timeout(function () {
                                    $scope.$broadcast("scrollToBottom", "notices_container",false,$scope.accounts[accountIndex].messages.length);
                                });
                            }
                            $scope.accounts[accountIndex].feed_id = data[data.length - 1].feed_id;
                            $scope.accounts[accountIndex].selectedItems = $scope.accounts[accountIndex].messages;
                            var length = $scope.accounts[accountIndex].messages.length;
                            if (length > 0) {
                                var lastId = $scope.accounts[accountIndex].messages[length - 1].feed_id;
                                var cachedLastId = notices.getLastNoticeId();
                                if (lastId > cachedLastId) {
                                    notices.callTotalUnread(lastId, cachedLastId);
                                }
                            }
                        }
                    }
                    $scope.isLoadingData = false;
                });
                if (callback) {
                    callback(data);
                }
            }, function (msg) {
                $scope.isLoadingData = false;
                log.logInfo("get receiver message failed. user_id:" + api.getCurrentUser().userId + "; account_id=" + accountId + "; msg:" + msg);
                utils.applyScope($scope, function () {
                    $scope.isLoadingData = false;
                    $timeout(function () {
                        $scope.$broadcast("scrollToBottom", "notices_container",true);
                    });
                });
                if (callback) {
                    callback(null);
                }
            });
        });
    };

    $scope.backToMessage = function () {
        $scope.selectedAccount.currentCategory = '';
        $scope.getMessages($scope.selectedAccount.board_id, 0, 0);
    };

    $scope.deletePreview = function (n, e) {
        if (n.type == 'preview') {
            if ($scope.selectedAccount && $scope.selectedAccount.selectedItems) {
                var index = $scope.selectedAccount.selectedItems.findIndex(function (item) {
                    return item.feed_id == n.feed_id;
                });
                if (index > 0) {
                    api.deleteNotice(n, function () {
                        log.logInfo('success to delete preview message:' + n.id);
                    }, function (msg) {
                        log.logInfo('fail to delete preview message: id:' + n.id + '; error message:' + msg);
                    });
                    $scope.selectedAccount.selectedItems.splice(index, 1);
                }
            }
        }
    };

    $scope.getCategoryText = function(){
        if(!$scope.selectedAccount){
            return '';
        }
        return notices.getCategoryName($scope.selectedAccount.category);
    };

    $scope.init = function () {
        if(!$scope.showFailedList){
            $scope.showNotices = false;
            $scope.isLoadingAccounts = true;
            $scope.accounts = [];
            $scope.ConversationTitle = notices.getConversationTitle();
        }
        api.getReceiverAccounts(0, 0, function (data) {
            utils.applyScope($scope, function () {
                $scope.isReloading = false;
                $scope.showRequestBtn = false;
                $scope.isListReloading = false;
                $scope.showFailedList = false;
                $scope.accounts = data;
                $scope.isLoadingAccounts = false;
                var length = $scope.accounts.length;
                if (length > 0) {
                    var lastId = $scope.accounts[0].feed_id;
                    var cachedLastId = notices.getLastNoticeId();
                    if (lastId > cachedLastId) {
                        notices.callTotalUnread(lastId, cachedLastId);
                    }
                }
                $scope.showSelectedBoardInfo();
            });
        }, function (msg) {
            if($scope.newMessageReceived){
                $scope.isListReloading = false;
                $scope.showFailedList = true;
            }else{
                $scope.isReloading = false;
                $scope.showRequestBtn = true;
            }
            log.logInfo("get receiver accounts failed. user_id:" + api.getCurrentUser().userId + "; msg:" + msg);
            api.notifyError(msg);
            utils.applyScope($scope, function () {
                $scope.isLoadingAccounts = false;
            });

        });
        $scope.categories = notices.getSupportCategories('receive');
    };

    //如果有选择的广播号，直接显示此广播号消息(通信录入口)
    $scope.showSelectedBoardInfo = function(){
        var savedBoardId = utils.getObjFromlocalStorage($scope.SAVED_BOARD_ID);
        if(savedBoardId){
            utils.removeObjFromlocalStorage($scope.SAVED_BOARD_ID);
            var index = $scope.accounts.findIndex(function(ac){
                return ac.board_id == savedBoardId;
            });
            if(index > -1){
                $scope.updateSelectedAccount($scope.accounts[index]);
            }
            return true;
        }
        return false;
    };

    $scope.init();

    $scope.getListTitle = function () {
        var title = '';
        if (!$scope.selectedAccount) {
            return title;
        }
        if ($scope.selectedAccount.currentCategory) {
            title = notices.getCategoryName($scope.selectedAccount.currentCategory);
        } else {
            title = $scope.selectedAccount.board_name;
        }
        return title;
    };

    $scope.createAccount = function(notice){
        var ac = {
            name: notice.accountName,
            avatar: notice.accountAvatar,
            title: notice.topic,
            board_id: notice.accountId,
            created_at: notice.createTimestamp,
            board_name: notice.accountName,
            feed_id: notice.feed_id,
            category:notice.category
        };
        api.getAccountUnreadCount([notice.accountId], function (data) {
            ac.unread_count = data[0].unread_count;
            //再次检验是否重复，因为异步获取未读数的网络延时，可能会导致重复加载
            var index = $scope.accounts.findIndex(function (acc) {
                return acc.board_id == ac.board_id;
            });
            if (index < 0) {
                utils.applyScope($scope, function () {
                    log.logInfo("un-shift new account : " + ac.name + ";id: " + ac.board_id);
                    $scope.accounts.unshift(ac);
                });
            }
        }, function (msg) {
            log.logInfo("fail to load account unread count:" + msg);
        });
    };

    $scope.getAccountUnreadCount = function(accountId){
        api.getAccountUnreadCount([accountId], function (data) {
            utils.applyScope($scope, function () {
                var index = $scope.accounts.findIndex(function (ac) {
                    return ac.board_id == accountId;
                });
                if(index > 0){
                    $scope.accounts[index].unread_count = data[0].unread_count;
                }
            });
        }, function (msg) {
            log.logInfo("fail to load account unread count:" + msg);
        });
    };

    $scope.handleOneMessage = function(feed_id){
        var max = 0, since = 0;
        var list = $scope.selectedAccount.messages;
        if (list && list.length > 0) {
            since = list[list.length - 1].feed_id;
        }
        if(since < feed_id){
            since = feed_id;
            max = feed_id;
            $scope.getMessages($scope.selectedAccount.board_id, since, max);
        }
    };

    $scope.handleOnCategory = function(category, boardId, feed_id){
        $scope.getCategoryData(boardId, category, feed_id, feed_id);
    };

    $scope.onNewMessageReceived = function (data, dataType) {
        $scope.showFailedList = $scope.showRequestBtn;
        $scope.showRequestBtn = false;
        $scope.newMessageReceived = true;
        var n = notices.notice.create();
        if(n.category != 'bbs'){
            return;
        }
        if (dataType == 'OA') {
            notices.notice.convertFromOAData(n, data);
        } else if (dataType == 'FEED') {
            notices.notice.convertFromFeedData(n, data);
        } else {
            return;
        }
        var index = $scope.accounts.findIndex(function (ac) {
            return ac.board_id == n.accountId;
        });
        if ($scope.selectedAccount && $scope.selectedAccount.board_id == n.accountId && !pages.isHidden()) {
            api.setOneNoticeRead(n.feed_id, function () {
            }, function (msg) {
                log.logInfo('fail to send one notice read: ' + msg);
            });
        }
        if(index < 0){
           $scope.init();
            return;
        }

        log.logInfo("account index: " + index);
        utils.applyScope($scope, function () {
            if (index < 0) {
                $scope.createAccount(n);
            } else {
                if ($scope.accounts[index].feed_id < n.feed_id) {
                    //更新账号内容
                    $scope.accounts[index].name = n.accountName;
                    $scope.accounts[index].avatar = n.accountAvatar;
                    $scope.accounts[index].title = n.topic;
                    $scope.accounts[index].created_at = n.createTimestamp;
                    $scope.accounts[index].unread_count += 1;
                    $scope.accounts[index].feed_id = n.feed_id;

                    //将此账号置顶
                    var account = $scope.accounts[index];
                    $scope.accounts.splice(index, 1);
                    $scope.accounts.unshift(account);

                    if (account === $scope.selectedAccount) {
                        if ($scope.selectedAccount.currentCategory == '') {
                            log.logInfo('start refresh message list, account id:' + account.board_id);
                            $scope.handleOneMessage(n.feed_id);
                        } else {
                            var category = $scope.selectedAccount.currentCategory;
                            if (category == n.category) {
                                log.logInfo('start refresh bbs list, account id:' + account.board_id + '; bbs\'s feed id: ' + n.feed_id);
                                $scope.getCategoryData(account.board_id, category, n.feed_id, n.feed_id);
                            }
                        }
                    }
                } else {
                    $scope.getAccountUnreadCount(n.accountId);
                }
            }
        });
    };

    $scope.onReplySubmit = function (data) {
        if (!$scope.selectedAccount) {
            return;
        }
        var accountId = data.board_id;
        var feedId = data.feed_id;
        if (accountId == $scope.selectedAccount.board_id) {
            $scope.getSelectedAccountTaskTodoCount(accountId);
            var category = $scope.selectedAccount.currentCategory;
            if (category == 'task') {
                var nIndex = $scope.selectedAccount.categories[category].findIndex(function (ca) {
                    return ca.feed_id == feedId;
                });
                if (nIndex > -1) {
                    var max = $scope.selectedAccount.categories[category][nIndex].feed_id;
                    log.logInfo('start refresh one task, account id:' + accountId + '; task\'s feed id: ' + max);
                    $scope.getCategoryData(accountId, category, max, max);
                }
            }
        }
    };



    var offNoticeReceived = $scope.$on("NewNoticeReceived", function (e, data) {
        log.logInfo("receive new notice received event:" + JSON.stringify(data));
        $scope.onNewMessageReceived(data, 'OA');
    });

    var offTaskReplySubmitted = $scope.$on("bbs_task_reply", function (e, data) {
        log.logInfo("receive one task reply submit event:" + JSON.stringify(data));
        // $scope.onReplySubmit(data);
    });

    var offNoticeReceived = $scope.$on("receive_feed_message", function (e, data) {
        log.logInfo("receive new feed message:" + JSON.stringify(data));
        $scope.onNewMessageReceived(data, 'FEED');
    });

    var offNoticeBatchRead = $scope.$on("ackread_batch", function (e, data) {
        log.logInfo("receive notice batch read event:" + JSON.stringify(data));
        var index = $scope.accounts.findIndex(function (ac) {
            return ac.board_id == data.board_id;
        });
        if (index < 0) {
            return;
        } else {
            api.getAccountUnreadCount([data.board_id], function (data) {
                utils.applyScope($scope, function () {
                    $scope.accounts[index].unread_count = data[0].unread_count;
                });
            }, function (msg) {
                log.logInfo("fail to load account unread count:" + msg);
            });
        }
    });

    var offNoticeReaded = $scope.$on("ackread", function (e, data) {
        log.logInfo("receive notice readed event:" + JSON.stringify(data));
        var index = $scope.accounts.findIndex(function (ac) {
            return ac.board_id == data.board_id;
        });
        if (index < 0) {
            return;
        } else {
            api.getAccountUnreadCount([data.board_id], function (data) {
                utils.applyScope($scope, function () {
                    $scope.accounts[index].unread_count = data[0].unread_count;
                });
            }, function (msg) {
                log.logInfo("fail to load account unread count:" + msg);
            });
        }
    });

    var offScopeBackToAccount = $scope.$on("BackToAccount", function () {
        utils.applyScope($scope, function () {
            if($scope.showSelectedBoardInfo()){
                return;
            }
            $scope.backToMain();
            if (!$scope.accounts || $scope.accounts.length === 0) { //当获取广播号列表失败时，帐号列表为空，每次显示i广播会话就刷新一次帐号列表
                $scope.init();
            }
        });
    });

    var offBoardDelete = $scope.$on("board_destroy", function (e, data) {
        log.logInfo("receive account delete event:" + JSON.stringify(data));
        var index = $scope.accounts.findIndex(function (ac) {
            return ac.board_id == data.board_id;
        });
        if (index > -1) {
            var name = $scope.accounts[index].board_name;
            utils.applyScope($scope, function () {
                if ($scope.selectedAccount == $scope.accounts[index]) {
                    $scope.selectedAccount = null;
                    $scope.backToMain();
                }
                $scope.accounts.splice(index, 1);
            });
            // notices.openUCAlert(translate.instant("common.account-delete-alert",{name:name}),function(){
            // });
        }

        //处理弹窗
        var selectedAccount = notices.retrieveSelectedAccount();
        if (selectedAccount && selectedAccount.id == data.board_id) {
            pages.fnCall("publishWindow", "onAccountInvalid", translate.instant("common.account-delete-alert", {name: selectedAccount.name}), function () {
            });
        }
    });

    var offBoardDelete = $scope.$on("destroy_msg", function (e, data) {
        log.logInfo("receive account delete event:" + JSON.stringify(data));
        var index = $scope.accounts.findIndex(function (ac) {
            return ac.board_id == data.board_id;
        });
        if (index > -1) {

            utils.applyScope($scope, function () {

                var bbsIdIndex = $scope.accounts[index].selectedItems.findIndex(function (ac) {
                    return ac.id == data.bbs_id;
                });

                if(bbsIdIndex > -1){
                    $scope.accounts[index].selectedItems.splice(bbsIdIndex,1);
                    if($scope.accounts[index].selectedItems.length < 5){
                        $scope.onScrollUp(function(){});
                    }

                }

            });
            var getBoardId = data.board_id;
            api.getAccountAllUnreadCount(data.board_id, function (data) {
                utils.applyScope($scope, function () {
                    if(getBoardId == data.board_data.board_id){
                        $scope.accounts[index].unread_count = data.board_data.unread_count;
                        $scope.accounts[index].title = data.board_data.last_bbs_info.title || "";
                    }

                });
            }, function (msg) {
                log.logInfo("fail to load account unread count:" + msg);
            });
            // notices.openUCAlert(translate.instant("common.account-delete-alert",{name:name}),function(){
            // });
        }
    });

    var offBoardEdit = $scope.$on("board_edit", function (e, data) {
        log.logInfo("receive account edit event:" + JSON.stringify(data));
        var index = $scope.accounts.findIndex(function (ac) {
            return ac.board_id == data.board_id;
        });
        if (index > -1) {
            utils.applyScope($scope, function () {
                $scope.accounts[index].board_name = data.board_name;
                $scope.accounts[index].avatar = data.avatar;
            });
        }
    });

    var offBoardUpdate = $scope.$on("board_update", function (e, data) {
        //处理弹窗
        var selectedAccount = notices.retrieveSelectedAccount();
        if (selectedAccount && selectedAccount.id == data.board_id) {
            var currentUser = utils.retrieveUser();
            var uIndex = data.editor_info.findIndex(function (user) {
                return user.user_id == currentUser.userId;
            });
            if (uIndex < 0) {
                pages.fnCall("publishWindow", "onAccountInvalid", translate.instant("common.no-account-right-alert", {name: selectedAccount.name}), function () {
                });
            } else {
                var ac = notices.account();
                ac.convertFromData(data);
                notices.saveSelectedAccount(ac);
                pages.fnCall("publishWindow", "updateAccount", ac, function () {
                });
            }
        }
    });

    var scrollToBottom = $scope.$on("to-parent", function (e, data) {
        //处理弹窗
        $timeout(function () {
        //    $scope.$broadcast("scrollToBottom", "notices_container");
        });
        $timeout(function () {
        //    $scope.$broadcast("scrollToBottom", "notices_container");
        },500);

    });

    var offOnInit = $scope.$on('Init', function () {
        $scope.init();
    });

    $scope.$on("$destroy", function () {
        offOnInit();
        offNoticeReceived();
        offNoticeReaded();
        // offNoticeDeleted();
        offScopeBackToAccount();
        offBoardDelete();
        offBoardEdit();
        offBoardUpdate();
        offNoticeBatchRead();
        offTaskReplySubmitted();
    });
}]);
